
/****** Object:  StoredProcedure [dbo].[P_EST_PROD_TRANSF_IT_LOTE_ALEATORIO]    Script Date: 17/12/2013 17:17:41 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_TRANSF_IT_LOTE_ALEATORIO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_TRANSF_IT_LOTE_ALEATORIO]
GO
GO
GO
--Versao 2446
--EXEC P_EST_PROD_TRANSF_IT_LOTE_ALEATORIO '2013-12-10'
CREATE PROCEDURE [dbo].[P_EST_PROD_TRANSF_IT_LOTE_ALEATORIO] @DT_PROC DATETIME AS 
	DECLARE @CD_EMP INT
	DECLARE @CD_FILIAL INT
	DECLARE @CD_CTR INT
	DECLARE @CD_PROD INT
	DECLARE @QT_AT MONEY
	 
	DECLARE cProdutoLote CURSOR FAST_FORWARD READ_ONLY FOR 
	select
		 EST_PROD_TRANSF.CD_EMP,
		 EST_PROD_TRANSF.CD_FILIAL,
		 EST_PROD_TRANSF.CD_CTR,
		 EST_PROD_TRANSF_IT.CD_PROD,
		 EST_PROD_TRANSF_IT.QT_AT
	from
		EST_PROD_TRANSF INNER JOIN EST_PROD_TRANSF_IT ON
		EST_PROD_TRANSF.CD_EMP = EST_PROD_TRANSF_IT.CD_EMP AND
		EST_PROD_TRANSF.CD_FILIAL = EST_PROD_TRANSF_IT.CD_FILIAL AND
		EST_PROD_TRANSF.CD_CTR = EST_PROD_TRANSF_IT.CD_CTR 
		LEFT OUTER JOIN EST_PROD_TRANSF_IT_LOTE ON
		EST_PROD_TRANSF_IT.CD_EMP = EST_PROD_TRANSF_IT_LOTE.CD_EMP AND
		EST_PROD_TRANSF_IT.CD_FILIAL = EST_PROD_TRANSF_IT_LOTE.CD_FILIAL AND
		EST_PROD_TRANSF_IT.CD_CTR = EST_PROD_TRANSF_IT_LOTE.CD_CTR AND
		EST_PROD_TRANSF_IT.CD_PROD = EST_PROD_TRANSF_IT_LOTE.CD_PROD
		INNER JOIN EST_PROD ON
		EST_PROD_TRANSF_IT.CD_EMP = EST_PROD.CD_EMP AND
		EST_PROD_TRANSF_IT.CD_PROD = EST_PROD.CD_PROD 
	WHERE
		EST_PROD_TRANSF_IT_LOTE.CD_EMP IS NULL
		AND EST_PROD.CTR_LOTE = 1
		AND EST_PROD_TRANSF.DT_TRANSF >= @DT_PROC
	ORDER BY	
		EST_PROD_TRANSF.CD_CTR, 
		EST_PROD_TRANSF_IT.CD_PROD

	OPEN cProdutoLote
	FETCH NEXT FROM cProdutoLote INTO @CD_EMP, @CD_FILIAL,@CD_CTR,@CD_PROD,@QT_AT 

	WHILE @@FETCH_STATUS=0
	BEGIN
		INSERT INTO EST_PROD_TRANSF_IT_LOTE
		SELECT
			TOP 1 CD_EMP,
			CD_FILIAL,
			@CD_CTR,
			CD_PROD, 
			NR_LOTE,
			DT_VALID,
			@QT_AT,
			DT_FABR 
		FROM
			EST_PROD_CPL_LOTE
		WHERE
			DT_VALID = (SELECT
							MAX(DT_VALID)
						FROM
							EST_PROD_CPL_LOTE L
						WHERE
							EST_PROD_CPL_LOTE.CD_EMP = L.CD_EMP AND
							EST_PROD_CPL_LOTE.CD_FILIAL = L.CD_FILIAL AND
							EST_PROD_CPL_LOTE.CD_PROD= L.CD_PROD )
			AND EST_PROD_CPL_LOTE.CD_EMP=@CD_EMP 
			AND EST_PROD_CPL_LOTE.CD_FILIAL = @CD_FILIAL
			AND EST_PROD_CPL_LOTE.CD_PROD = @CD_PROD

	FETCH NEXT FROM cProdutoLote INTO @CD_EMP, @CD_FILIAL,@CD_CTR,@CD_PROD,@QT_AT 
	END
	
CLOSE cProdutoLote
DEALLOCATE cProdutoLote